function [ac]=autocorrelations(x,nlag)
%	AUTOCORRELATIONS - [ac]=autocorrelations(x,nlag): x is a (T x m) matrix

[n,m]=size(x);
acv = repmat(NaN,nlag+1,m);
x = x - repmat(mean(x,1),n,1);
for ilag=0:min(nlag,n-1);
   acv(ilag+1,:) = sum( x(1+ilag:end,:).*x(1:n-ilag,:), 1)/(n-ilag);
end
acv(1,(acv(1,:)==0))=NaN;
ac = acv ./ repmat(acv(1,:),nlag+1,1);